import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsAmiConfig extends TerraformMetaArguments {
    readonly executableUsers?: string[];
    readonly mostRecent?: boolean;
    readonly nameRegex?: string;
    readonly owners: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsAmiFilter[];
}
export declare class DataAwsAmiBlockDeviceMappings extends ComplexComputedList {
    get deviceName(): string;
    get ebs(): any;
    get noDevice(): string;
    get virtualName(): string;
}
export declare class DataAwsAmiProductCodes extends ComplexComputedList {
    get productCodeId(): string;
    get productCodeType(): string;
}
export interface DataAwsAmiFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsAmi extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsAmiConfig);
    get architecture(): string;
    get arn(): string;
    blockDeviceMappings(index: string): DataAwsAmiBlockDeviceMappings;
    get creationDate(): string;
    get description(): string;
    private _executableUsers?;
    get executableUsers(): string[] | undefined;
    set executableUsers(value: string[] | undefined);
    get hypervisor(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get imageId(): string;
    get imageLocation(): string;
    get imageOwnerAlias(): string;
    get imageType(): string;
    get kernelId(): string;
    private _mostRecent?;
    get mostRecent(): boolean | undefined;
    set mostRecent(value: boolean | undefined);
    get name(): string;
    private _nameRegex?;
    get nameRegex(): string | undefined;
    set nameRegex(value: string | undefined);
    get ownerId(): string;
    private _owners;
    get owners(): string[];
    set owners(value: string[]);
    get platform(): string;
    productCodes(index: string): DataAwsAmiProductCodes;
    get public(): boolean;
    get ramdiskId(): string;
    get rootDeviceName(): string;
    get rootDeviceType(): string;
    get rootSnapshotId(): string;
    get sriovNetSupport(): string;
    get state(): string;
    stateReason(key: string): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get virtualizationType(): string;
    private _filter?;
    get filter(): DataAwsAmiFilter[] | undefined;
    set filter(value: DataAwsAmiFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
