import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsApiGatewayRestApiConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsApiGatewayRestApiEndpointConfiguration extends ComplexComputedList {
    get types(): string[];
    get vpcEndpointIds(): string[];
}
export declare class DataAwsApiGatewayRestApi extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsApiGatewayRestApiConfig);
    get apiKeySource(): string;
    get arn(): string;
    get binaryMediaTypes(): string[];
    get description(): string;
    endpointConfiguration(index: string): DataAwsApiGatewayRestApiEndpointConfiguration;
    get executionArn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get minimumCompressionSize(): number;
    private _name;
    get name(): string;
    set name(value: string);
    get policy(): string;
    get rootResourceId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
