import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsCloudhsmV2ClusterConfig extends TerraformMetaArguments {
    readonly clusterId: string;
    readonly clusterState?: string;
}
export declare class DataAwsCloudhsmV2ClusterClusterCertificates extends ComplexComputedList {
    get awsHardwareCertificate(): string;
    get clusterCertificate(): string;
    get clusterCsr(): string;
    get hsmCertificate(): string;
    get manufacturerHardwareCertificate(): string;
}
export declare class DataAwsCloudhsmV2Cluster extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsCloudhsmV2ClusterConfig);
    clusterCertificates(index: string): DataAwsCloudhsmV2ClusterClusterCertificates;
    private _clusterId;
    get clusterId(): string;
    set clusterId(value: string);
    private _clusterState?;
    get clusterState(): string | undefined;
    set clusterState(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get securityGroupId(): string;
    get subnetIds(): string[];
    get vpcId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
