"use strict";
// https://www.terraform.io/docs/providers/aws/r/data_aws_cur_report_definition.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAwsCurReportDefinition = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DataAwsCurReportDefinition extends cdktf_1.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_cur_report_definition',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._reportName = config.reportName;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // additional_artifacts - computed: true, optional: false, required: true
    get additionalArtifacts() {
        return this.getListAttribute('additional_artifacts');
    }
    // additional_schema_elements - computed: true, optional: false, required: true
    get additionalSchemaElements() {
        return this.getListAttribute('additional_schema_elements');
    }
    // compression - computed: true, optional: false, required: true
    get compression() {
        return this.getStringAttribute('compression');
    }
    // format - computed: true, optional: false, required: true
    get format() {
        return this.getStringAttribute('format');
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get reportName() {
        return this._reportName;
    }
    set reportName(value) {
        this._reportName = value;
    }
    // s3_bucket - computed: true, optional: false, required: true
    get s3Bucket() {
        return this.getStringAttribute('s3_bucket');
    }
    // s3_prefix - computed: true, optional: false, required: true
    get s3Prefix() {
        return this.getStringAttribute('s3_prefix');
    }
    // s3_region - computed: true, optional: false, required: true
    get s3Region() {
        return this.getStringAttribute('s3_region');
    }
    // time_unit - computed: true, optional: false, required: true
    get timeUnit() {
        return this.getStringAttribute('time_unit');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            report_name: this._reportName,
        };
    }
}
exports.DataAwsCurReportDefinition = DataAwsCurReportDefinition;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS1hd3MtY3VyLXJlcG9ydC1kZWZpbml0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2RhdGEtYXdzLWN1ci1yZXBvcnQtZGVmaW5pdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsb0ZBQW9GO0FBQ3BGLDJDQUEyQzs7O0FBMkQzQyxpQ0FBNEM7QUFTNUMsV0FBVztBQUVYLE1BQWEsMEJBQTJCLFNBQVEsMkJBQW1CO0lBRWpFLGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQXdDO1FBQ3ZGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsMkJBQTJCO1lBQ2xELDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsS0FBSzthQUNwQjtZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztTQUM1QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7SUFDdkMsQ0FBQztJQUVELGFBQWE7SUFDYixhQUFhO0lBQ2IsYUFBYTtJQUViLHlFQUF5RTtJQUN6RSxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFFRCwrRUFBK0U7SUFDL0UsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsNEJBQTRCLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBRUQsZ0VBQWdFO0lBQ2hFLElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBRUQsMkRBQTJEO0lBQzNELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFJRCxJQUFXLEVBQUU7O1FBQ1gsYUFBTyxJQUFJLENBQUMsR0FBRyxtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQXlCO1FBQ3JDLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFFRCw4REFBOEQ7SUFDOUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRCw4REFBOEQ7SUFDOUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRCw4REFBOEQ7SUFDOUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRCw4REFBOEQ7SUFDOUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRCxZQUFZO0lBQ1osWUFBWTtJQUNaLFlBQVk7SUFFTCxvQkFBb0I7UUFDekIsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztTQUM5QixDQUFDO0lBQ0osQ0FBQztDQUNGO0FBM0ZELGdFQTJGQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9hd3Mvci9kYXRhX2F3c19jdXJfcmVwb3J0X2RlZmluaXRpb24uaHRtbFxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG4vKlxue1xuICBcInZlcnNpb25cIjogMCxcbiAgXCJibG9ja1wiOiB7XG4gICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgIFwiYWRkaXRpb25hbF9hcnRpZmFjdHNcIjoge1xuICAgICAgICBcInR5cGVcIjogW1xuICAgICAgICAgIFwic2V0XCIsXG4gICAgICAgICAgXCJzdHJpbmdcIlxuICAgICAgICBdLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImFkZGl0aW9uYWxfc2NoZW1hX2VsZW1lbnRzXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICBcInNldFwiLFxuICAgICAgICAgIFwic3RyaW5nXCJcbiAgICAgICAgXSxcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJjb21wcmVzc2lvblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImZvcm1hdFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImlkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgXCJjb21wdXRlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJyZXBvcnRfbmFtZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInMzX2J1Y2tldFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInMzX3ByZWZpeFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInMzX3JlZ2lvblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInRpbWVfdW5pdFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH1cbiAgICB9XG4gIH1cbn1cbiovXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFRlcnJhZm9ybURhdGFTb3VyY2UgfSBmcm9tICdjZGt0Zic7XG5pbXBvcnQgeyBUZXJyYWZvcm1NZXRhQXJndW1lbnRzIH0gZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgRGF0YUF3c0N1clJlcG9ydERlZmluaXRpb25Db25maWcgZXh0ZW5kcyBUZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgcmVhZG9ubHkgcmVwb3J0TmFtZTogc3RyaW5nO1xufVxuXG4vLyBSZXNvdXJjZVxuXG5leHBvcnQgY2xhc3MgRGF0YUF3c0N1clJlcG9ydERlZmluaXRpb24gZXh0ZW5kcyBUZXJyYWZvcm1EYXRhU291cmNlIHtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IERhdGFBd3NDdXJSZXBvcnREZWZpbml0aW9uQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3NfY3VyX3JlcG9ydF9kZWZpbml0aW9uJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F3cydcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX3JlcG9ydE5hbWUgPSBjb25maWcucmVwb3J0TmFtZTtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYWRkaXRpb25hbF9hcnRpZmFjdHMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwdWJsaWMgZ2V0IGFkZGl0aW9uYWxBcnRpZmFjdHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgnYWRkaXRpb25hbF9hcnRpZmFjdHMnKTtcbiAgfVxuXG4gIC8vIGFkZGl0aW9uYWxfc2NoZW1hX2VsZW1lbnRzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBhZGRpdGlvbmFsU2NoZW1hRWxlbWVudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgnYWRkaXRpb25hbF9zY2hlbWFfZWxlbWVudHMnKTtcbiAgfVxuXG4gIC8vIGNvbXByZXNzaW9uIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBjb21wcmVzc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NvbXByZXNzaW9uJyk7XG4gIH1cblxuICAvLyBmb3JtYXQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwdWJsaWMgZ2V0IGZvcm1hdCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2Zvcm1hdCcpO1xuICB9XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZztcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQgPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHJlcG9ydF9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3JlcG9ydE5hbWU6IHN0cmluZztcbiAgcHVibGljIGdldCByZXBvcnROYW1lKCkge1xuICAgIHJldHVybiB0aGlzLl9yZXBvcnROYW1lO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVwb3J0TmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVwb3J0TmFtZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gczNfYnVja2V0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBzM0J1Y2tldCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3MzX2J1Y2tldCcpO1xuICB9XG5cbiAgLy8gczNfcHJlZml4IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBzM1ByZWZpeCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3MzX3ByZWZpeCcpO1xuICB9XG5cbiAgLy8gczNfcmVnaW9uIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCBzM1JlZ2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3MzX3JlZ2lvbicpO1xuICB9XG5cbiAgLy8gdGltZV91bml0IC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHVibGljIGdldCB0aW1lVW5pdCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3RpbWVfdW5pdCcpO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwdWJsaWMgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICByZXBvcnRfbmFtZTogdGhpcy5fcmVwb3J0TmFtZSxcbiAgICB9O1xuICB9XG59XG4iXX0=