import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsDbClusterSnapshotConfig extends TerraformMetaArguments {
    readonly dbClusterIdentifier?: string;
    readonly dbClusterSnapshotIdentifier?: string;
    readonly includePublic?: boolean;
    readonly includeShared?: boolean;
    readonly mostRecent?: boolean;
    readonly snapshotType?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsDbClusterSnapshot extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsDbClusterSnapshotConfig);
    get allocatedStorage(): number;
    get availabilityZones(): string[];
    private _dbClusterIdentifier?;
    get dbClusterIdentifier(): string | undefined;
    set dbClusterIdentifier(value: string | undefined);
    get dbClusterSnapshotArn(): string;
    private _dbClusterSnapshotIdentifier?;
    get dbClusterSnapshotIdentifier(): string | undefined;
    set dbClusterSnapshotIdentifier(value: string | undefined);
    get engine(): string;
    get engineVersion(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _includePublic?;
    get includePublic(): boolean | undefined;
    set includePublic(value: boolean | undefined);
    private _includeShared?;
    get includeShared(): boolean | undefined;
    set includeShared(value: boolean | undefined);
    get kmsKeyId(): string;
    get licenseModel(): string;
    private _mostRecent?;
    get mostRecent(): boolean | undefined;
    set mostRecent(value: boolean | undefined);
    get port(): number;
    get snapshotCreateTime(): string;
    private _snapshotType?;
    get snapshotType(): string | undefined;
    set snapshotType(value: string | undefined);
    get sourceDbClusterSnapshotArn(): string;
    get status(): string;
    get storageEncrypted(): boolean;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
