import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsDbInstanceConfig extends TerraformMetaArguments {
    readonly dbInstanceIdentifier: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsDbInstance extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsDbInstanceConfig);
    get address(): string;
    get allocatedStorage(): number;
    get autoMinorVersionUpgrade(): boolean;
    get availabilityZone(): string;
    get backupRetentionPeriod(): number;
    get caCertIdentifier(): string;
    get dbClusterIdentifier(): string;
    get dbInstanceArn(): string;
    get dbInstanceClass(): string;
    private _dbInstanceIdentifier;
    get dbInstanceIdentifier(): string;
    set dbInstanceIdentifier(value: string);
    get dbInstancePort(): number;
    get dbName(): string;
    get dbParameterGroups(): string[];
    get dbSecurityGroups(): string[];
    get dbSubnetGroup(): string;
    get enabledCloudwatchLogsExports(): string[];
    get endpoint(): string;
    get engine(): string;
    get engineVersion(): string;
    get hostedZoneId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get iops(): number;
    get kmsKeyId(): string;
    get licenseModel(): string;
    get masterUsername(): string;
    get monitoringInterval(): number;
    get monitoringRoleArn(): string;
    get multiAz(): boolean;
    get optionGroupMemberships(): string[];
    get port(): number;
    get preferredBackupWindow(): string;
    get preferredMaintenanceWindow(): string;
    get publiclyAccessible(): boolean;
    get replicateSourceDb(): string;
    get resourceId(): string;
    get storageEncrypted(): boolean;
    get storageType(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get timezone(): string;
    get vpcSecurityGroups(): string[];
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
