import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsDbSnapshotConfig extends TerraformMetaArguments {
    readonly dbInstanceIdentifier?: string;
    readonly dbSnapshotIdentifier?: string;
    readonly includePublic?: boolean;
    readonly includeShared?: boolean;
    readonly mostRecent?: boolean;
    readonly snapshotType?: string;
}
export declare class DataAwsDbSnapshot extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsDbSnapshotConfig);
    get allocatedStorage(): number;
    get availabilityZone(): string;
    private _dbInstanceIdentifier?;
    get dbInstanceIdentifier(): string | undefined;
    set dbInstanceIdentifier(value: string | undefined);
    get dbSnapshotArn(): string;
    private _dbSnapshotIdentifier?;
    get dbSnapshotIdentifier(): string | undefined;
    set dbSnapshotIdentifier(value: string | undefined);
    get encrypted(): boolean;
    get engine(): string;
    get engineVersion(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _includePublic?;
    get includePublic(): boolean | undefined;
    set includePublic(value: boolean | undefined);
    private _includeShared?;
    get includeShared(): boolean | undefined;
    set includeShared(value: boolean | undefined);
    get iops(): number;
    get kmsKeyId(): string;
    get licenseModel(): string;
    private _mostRecent?;
    get mostRecent(): boolean | undefined;
    set mostRecent(value: boolean | undefined);
    get optionGroupName(): string;
    get port(): number;
    get snapshotCreateTime(): string;
    private _snapshotType?;
    get snapshotType(): string | undefined;
    set snapshotType(value: string | undefined);
    get sourceDbSnapshotIdentifier(): string;
    get sourceRegion(): string;
    get status(): string;
    get storageType(): string;
    get vpcId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
