import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsDirectoryServiceDirectoryConfig extends TerraformMetaArguments {
    readonly directoryId: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsDirectoryServiceDirectoryConnectSettings extends ComplexComputedList {
    get availabilityZones(): string[];
    get connectIps(): string[];
    get customerDnsIps(): string[];
    get customerUsername(): string;
    get subnetIds(): string[];
    get vpcId(): string;
}
export declare class DataAwsDirectoryServiceDirectoryVpcSettings extends ComplexComputedList {
    get availabilityZones(): string[];
    get subnetIds(): string[];
    get vpcId(): string;
}
export declare class DataAwsDirectoryServiceDirectory extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsDirectoryServiceDirectoryConfig);
    get accessUrl(): string;
    get alias(): string;
    connectSettings(index: string): DataAwsDirectoryServiceDirectoryConnectSettings;
    get description(): string;
    private _directoryId;
    get directoryId(): string;
    set directoryId(value: string);
    get dnsIpAddresses(): string[];
    get edition(): string;
    get enableSso(): boolean;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get name(): string;
    get securityGroupId(): string;
    get shortName(): string;
    get size(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get type(): string;
    vpcSettings(index: string): DataAwsDirectoryServiceDirectoryVpcSettings;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
