import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsDynamodbTableConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** server_side_encryption block */
    readonly serverSideEncryption?: DataAwsDynamodbTableServerSideEncryption[];
}
export declare class DataAwsDynamodbTableAttribute extends ComplexComputedList {
    get name(): string;
    get type(): string;
}
export declare class DataAwsDynamodbTableGlobalSecondaryIndex extends ComplexComputedList {
    get hashKey(): string;
    get name(): string;
    get nonKeyAttributes(): string[];
    get projectionType(): string;
    get rangeKey(): string;
    get readCapacity(): number;
    get writeCapacity(): number;
}
export declare class DataAwsDynamodbTableLocalSecondaryIndex extends ComplexComputedList {
    get name(): string;
    get nonKeyAttributes(): string[];
    get projectionType(): string;
    get rangeKey(): string;
}
export declare class DataAwsDynamodbTablePointInTimeRecovery extends ComplexComputedList {
    get enabled(): boolean;
}
export declare class DataAwsDynamodbTableReplica extends ComplexComputedList {
    get regionName(): string;
}
export declare class DataAwsDynamodbTableTtl extends ComplexComputedList {
    get attributeName(): string;
    get enabled(): boolean;
}
export interface DataAwsDynamodbTableServerSideEncryption {
}
export declare class DataAwsDynamodbTable extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsDynamodbTableConfig);
    get arn(): string;
    attribute(index: string): DataAwsDynamodbTableAttribute;
    get billingMode(): string;
    globalSecondaryIndex(index: string): DataAwsDynamodbTableGlobalSecondaryIndex;
    get hashKey(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    localSecondaryIndex(index: string): DataAwsDynamodbTableLocalSecondaryIndex;
    private _name;
    get name(): string;
    set name(value: string);
    pointInTimeRecovery(index: string): DataAwsDynamodbTablePointInTimeRecovery;
    get rangeKey(): string;
    get readCapacity(): number;
    replica(index: string): DataAwsDynamodbTableReplica;
    get streamArn(): string;
    get streamEnabled(): boolean;
    get streamLabel(): string;
    get streamViewType(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    ttl(index: string): DataAwsDynamodbTableTtl;
    get writeCapacity(): number;
    private _serverSideEncryption?;
    get serverSideEncryption(): DataAwsDynamodbTableServerSideEncryption[] | undefined;
    set serverSideEncryption(value: DataAwsDynamodbTableServerSideEncryption[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
