import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsEbsSnapshotConfig extends TerraformMetaArguments {
    readonly mostRecent?: boolean;
    readonly owners?: string[];
    readonly restorableByUserIds?: string[];
    readonly snapshotIds?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsEbsSnapshotFilter[];
}
export interface DataAwsEbsSnapshotFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsEbsSnapshot extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsEbsSnapshotConfig);
    get arn(): string;
    get dataEncryptionKeyId(): string;
    get description(): string;
    get encrypted(): boolean;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kmsKeyId(): string;
    private _mostRecent?;
    get mostRecent(): boolean | undefined;
    set mostRecent(value: boolean | undefined);
    get ownerAlias(): string;
    get ownerId(): string;
    private _owners?;
    get owners(): string[] | undefined;
    set owners(value: string[] | undefined);
    private _restorableByUserIds?;
    get restorableByUserIds(): string[] | undefined;
    set restorableByUserIds(value: string[] | undefined);
    get snapshotId(): string;
    private _snapshotIds?;
    get snapshotIds(): string[] | undefined;
    set snapshotIds(value: string[] | undefined);
    get state(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get volumeId(): string;
    get volumeSize(): number;
    private _filter?;
    get filter(): DataAwsEbsSnapshotFilter[] | undefined;
    set filter(value: DataAwsEbsSnapshotFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
