import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsEbsVolumeConfig extends TerraformMetaArguments {
    readonly mostRecent?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsEbsVolumeFilter[];
}
export interface DataAwsEbsVolumeFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsEbsVolume extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsEbsVolumeConfig);
    get arn(): string;
    get availabilityZone(): string;
    get encrypted(): boolean;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get iops(): number;
    get kmsKeyId(): string;
    private _mostRecent?;
    get mostRecent(): boolean | undefined;
    set mostRecent(value: boolean | undefined);
    get multiAttachEnabled(): boolean;
    get outpostArn(): string;
    get size(): number;
    get snapshotId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get volumeId(): string;
    get volumeType(): string;
    private _filter?;
    get filter(): DataAwsEbsVolumeFilter[] | undefined;
    set filter(value: DataAwsEbsVolumeFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
