import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsEc2CoipPoolConfig extends TerraformMetaArguments {
    readonly localGatewayRouteTableId?: string;
    readonly poolId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsEc2CoipPoolFilter[];
}
export interface DataAwsEc2CoipPoolFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsEc2CoipPool extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsEc2CoipPoolConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _localGatewayRouteTableId?;
    get localGatewayRouteTableId(): string | undefined;
    set localGatewayRouteTableId(value: string | undefined);
    get poolCidrs(): string[];
    private _poolId?;
    get poolId(): string | undefined;
    set poolId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _filter?;
    get filter(): DataAwsEc2CoipPoolFilter[] | undefined;
    set filter(value: DataAwsEc2CoipPoolFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
