import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsEc2LocalGatewayVirtualInterfaceConfig extends TerraformMetaArguments {
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsEc2LocalGatewayVirtualInterfaceFilter[];
}
export interface DataAwsEc2LocalGatewayVirtualInterfaceFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsEc2LocalGatewayVirtualInterface extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsEc2LocalGatewayVirtualInterfaceConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get localAddress(): string;
    get localBgpAsn(): number;
    get localGatewayId(): string;
    get localGatewayVirtualInterfaceIds(): string[];
    get peerAddress(): string;
    get peerBgpAsn(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vlan(): number;
    private _filter?;
    get filter(): DataAwsEc2LocalGatewayVirtualInterfaceFilter[] | undefined;
    set filter(value: DataAwsEc2LocalGatewayVirtualInterfaceFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
