import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsEc2TransitGatewayConfig extends TerraformMetaArguments {
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsEc2TransitGatewayFilter[];
}
export interface DataAwsEc2TransitGatewayFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsEc2TransitGateway extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsEc2TransitGatewayConfig);
    get amazonSideAsn(): number;
    get arn(): string;
    get associationDefaultRouteTableId(): string;
    get autoAcceptSharedAttachments(): string;
    get defaultRouteTableAssociation(): string;
    get defaultRouteTablePropagation(): string;
    get description(): string;
    get dnsSupport(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ownerId(): string;
    get propagationDefaultRouteTableId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpnEcmpSupport(): string;
    private _filter?;
    get filter(): DataAwsEc2TransitGatewayFilter[] | undefined;
    set filter(value: DataAwsEc2TransitGatewayFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
