import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsEfsAccessPointConfig extends TerraformMetaArguments {
    readonly accessPointId: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsEfsAccessPointPosixUser extends ComplexComputedList {
    get gid(): number;
    get secondaryGids(): any;
    get uid(): number;
}
export declare class DataAwsEfsAccessPointRootDirectoryCreationInfo extends ComplexComputedList {
    get ownerGid(): number;
    get ownerUid(): number;
    get permissions(): string;
}
export declare class DataAwsEfsAccessPointRootDirectory extends ComplexComputedList {
    get creationInfo(): any;
    get path(): string;
}
export declare class DataAwsEfsAccessPoint extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsEfsAccessPointConfig);
    private _accessPointId;
    get accessPointId(): string;
    set accessPointId(value: string);
    get arn(): string;
    get fileSystemArn(): string;
    get fileSystemId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ownerId(): string;
    posixUser(index: string): DataAwsEfsAccessPointPosixUser;
    rootDirectory(index: string): DataAwsEfsAccessPointRootDirectory;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
