import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsEfsFileSystemConfig extends TerraformMetaArguments {
    readonly creationToken?: string;
    readonly fileSystemId?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsEfsFileSystemLifecyclePolicy extends ComplexComputedList {
    get transitionToIa(): string;
}
export declare class DataAwsEfsFileSystem extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsEfsFileSystemConfig);
    get arn(): string;
    private _creationToken?;
    get creationToken(): string | undefined;
    set creationToken(value: string | undefined);
    get dnsName(): string;
    get encrypted(): boolean;
    private _fileSystemId?;
    get fileSystemId(): string | undefined;
    set fileSystemId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kmsKeyId(): string;
    lifecyclePolicy(index: string): DataAwsEfsFileSystemLifecyclePolicy;
    get performanceMode(): string;
    get provisionedThroughputInMibps(): number;
    get sizeInBytes(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get throughputMode(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
