import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsEipConfig extends TerraformMetaArguments {
    readonly publicIp?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsEipFilter[];
}
export interface DataAwsEipFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsEip extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsEipConfig);
    get associationId(): string;
    get customerOwnedIp(): string;
    get customerOwnedIpv4Pool(): string;
    get domain(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get instanceId(): string;
    get networkInterfaceId(): string;
    get networkInterfaceOwnerId(): string;
    get privateDns(): string;
    get privateIp(): string;
    get publicDns(): string;
    private _publicIp?;
    get publicIp(): string | undefined;
    set publicIp(value: string | undefined);
    get publicIpv4Pool(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _filter?;
    get filter(): DataAwsEipFilter[] | undefined;
    set filter(value: DataAwsEipFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
