import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsEksClusterConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsEksClusterCertificateAuthority extends ComplexComputedList {
    get data(): string;
}
export declare class DataAwsEksClusterIdentityOidc extends ComplexComputedList {
    get issuer(): string;
}
export declare class DataAwsEksClusterIdentity extends ComplexComputedList {
    get oidc(): any;
}
export declare class DataAwsEksClusterVpcConfig extends ComplexComputedList {
    get clusterSecurityGroupId(): string;
    get endpointPrivateAccess(): boolean;
    get endpointPublicAccess(): boolean;
    get publicAccessCidrs(): string[];
    get securityGroupIds(): string[];
    get subnetIds(): string[];
    get vpcId(): string;
}
export declare class DataAwsEksCluster extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsEksClusterConfig);
    get arn(): string;
    certificateAuthority(index: string): DataAwsEksClusterCertificateAuthority;
    get createdAt(): string;
    get enabledClusterLogTypes(): string[];
    get endpoint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    identity(index: string): DataAwsEksClusterIdentity;
    private _name;
    get name(): string;
    set name(value: string);
    get platformVersion(): string;
    get roleArn(): string;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get version(): string;
    vpcConfig(index: string): DataAwsEksClusterVpcConfig;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
