import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsElasticacheClusterConfig extends TerraformMetaArguments {
    readonly clusterId: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsElasticacheClusterCacheNodes extends ComplexComputedList {
    get address(): string;
    get availabilityZone(): string;
    get id(): string;
    get port(): number;
}
export declare class DataAwsElasticacheCluster extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsElasticacheClusterConfig);
    get arn(): string;
    get availabilityZone(): string;
    cacheNodes(index: string): DataAwsElasticacheClusterCacheNodes;
    get clusterAddress(): string;
    private _clusterId;
    get clusterId(): string;
    set clusterId(value: string);
    get configurationEndpoint(): string;
    get engine(): string;
    get engineVersion(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get maintenanceWindow(): string;
    get nodeType(): string;
    get notificationTopicArn(): string;
    get numCacheNodes(): number;
    get parameterGroupName(): string;
    get port(): number;
    get replicationGroupId(): string;
    get securityGroupIds(): string[];
    get securityGroupNames(): string[];
    get snapshotRetentionLimit(): number;
    get snapshotWindow(): string;
    get subnetGroupName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
