import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsElasticsearchDomainConfig extends TerraformMetaArguments {
    readonly domainName: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsElasticsearchDomainAdvancedSecurityOptions extends ComplexComputedList {
    get enabled(): boolean;
    get internalUserDatabaseEnabled(): boolean;
}
export declare class DataAwsElasticsearchDomainClusterConfigZoneAwarenessConfig extends ComplexComputedList {
    get availabilityZoneCount(): number;
}
export declare class DataAwsElasticsearchDomainClusterConfig extends ComplexComputedList {
    get dedicatedMasterCount(): number;
    get dedicatedMasterEnabled(): boolean;
    get dedicatedMasterType(): string;
    get instanceCount(): number;
    get instanceType(): string;
    get warmCount(): number;
    get warmEnabled(): boolean;
    get warmType(): string;
    get zoneAwarenessConfig(): any;
    get zoneAwarenessEnabled(): boolean;
}
export declare class DataAwsElasticsearchDomainCognitoOptions extends ComplexComputedList {
    get enabled(): boolean;
    get identityPoolId(): string;
    get roleArn(): string;
    get userPoolId(): string;
}
export declare class DataAwsElasticsearchDomainEbsOptions extends ComplexComputedList {
    get ebsEnabled(): boolean;
    get iops(): number;
    get volumeSize(): number;
    get volumeType(): string;
}
export declare class DataAwsElasticsearchDomainEncryptionAtRest extends ComplexComputedList {
    get enabled(): boolean;
    get kmsKeyId(): string;
}
export declare class DataAwsElasticsearchDomainLogPublishingOptions extends ComplexComputedList {
    get cloudwatchLogGroupArn(): string;
    get enabled(): boolean;
    get logType(): string;
}
export declare class DataAwsElasticsearchDomainNodeToNodeEncryption extends ComplexComputedList {
    get enabled(): boolean;
}
export declare class DataAwsElasticsearchDomainSnapshotOptions extends ComplexComputedList {
    get automatedSnapshotStartHour(): number;
}
export declare class DataAwsElasticsearchDomainVpcOptions extends ComplexComputedList {
    get availabilityZones(): string[];
    get securityGroupIds(): string[];
    get subnetIds(): string[];
    get vpcId(): string;
}
export declare class DataAwsElasticsearchDomain extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsElasticsearchDomainConfig);
    get accessPolicies(): string;
    advancedOptions(key: string): string;
    advancedSecurityOptions(index: string): DataAwsElasticsearchDomainAdvancedSecurityOptions;
    get arn(): string;
    clusterConfig(index: string): DataAwsElasticsearchDomainClusterConfig;
    cognitoOptions(index: string): DataAwsElasticsearchDomainCognitoOptions;
    get created(): boolean;
    get deleted(): boolean;
    get domainId(): string;
    private _domainName;
    get domainName(): string;
    set domainName(value: string);
    ebsOptions(index: string): DataAwsElasticsearchDomainEbsOptions;
    get elasticsearchVersion(): string;
    encryptionAtRest(index: string): DataAwsElasticsearchDomainEncryptionAtRest;
    get endpoint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kibanaEndpoint(): string;
    logPublishingOptions(index: string): DataAwsElasticsearchDomainLogPublishingOptions;
    nodeToNodeEncryption(index: string): DataAwsElasticsearchDomainNodeToNodeEncryption;
    get processing(): boolean;
    snapshotOptions(index: string): DataAwsElasticsearchDomainSnapshotOptions;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    vpcOptions(index: string): DataAwsElasticsearchDomainVpcOptions;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
