import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsElbConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsElbAccessLogs extends ComplexComputedList {
    get bucket(): string;
    get bucketPrefix(): string;
    get enabled(): boolean;
    get interval(): number;
}
export declare class DataAwsElbHealthCheck extends ComplexComputedList {
    get healthyThreshold(): number;
    get interval(): number;
    get target(): string;
    get timeout(): number;
    get unhealthyThreshold(): number;
}
export declare class DataAwsElbListener extends ComplexComputedList {
    get instancePort(): number;
    get instanceProtocol(): string;
    get lbPort(): number;
    get lbProtocol(): string;
    get sslCertificateId(): string;
}
export declare class DataAwsElb extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsElbConfig);
    accessLogs(index: string): DataAwsElbAccessLogs;
    get arn(): string;
    get availabilityZones(): string[];
    get connectionDraining(): boolean;
    get connectionDrainingTimeout(): number;
    get crossZoneLoadBalancing(): boolean;
    get dnsName(): string;
    healthCheck(index: string): DataAwsElbHealthCheck;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get idleTimeout(): number;
    get instances(): string[];
    get internal(): boolean;
    listener(index: string): DataAwsElbListener;
    private _name;
    get name(): string;
    set name(value: string);
    get securityGroups(): string[];
    get sourceSecurityGroup(): string;
    get sourceSecurityGroupId(): string;
    get subnets(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get zoneId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
