import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsGlueScriptConfig extends TerraformMetaArguments {
    readonly language?: string;
    /** dag_edge block */
    readonly dagEdge: DataAwsGlueScriptDagEdge[];
    /** dag_node block */
    readonly dagNode: DataAwsGlueScriptDagNode[];
}
export interface DataAwsGlueScriptDagEdge {
    readonly source: string;
    readonly target: string;
    readonly targetParameter?: string;
}
export interface DataAwsGlueScriptDagNodeArgs {
    readonly name: string;
    readonly param?: boolean;
    readonly value: string;
}
export interface DataAwsGlueScriptDagNode {
    readonly id: string;
    readonly lineNumber?: number;
    readonly nodeType: string;
    /** args block */
    readonly args: DataAwsGlueScriptDagNodeArgs[];
}
export declare class DataAwsGlueScript extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsGlueScriptConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _language?;
    get language(): string | undefined;
    set language(value: string | undefined);
    get pythonScript(): string;
    get scalaCode(): string;
    private _dagEdge;
    get dagEdge(): DataAwsGlueScriptDagEdge[];
    set dagEdge(value: DataAwsGlueScriptDagEdge[]);
    private _dagNode;
    get dagNode(): DataAwsGlueScriptDagNode[];
    set dagNode(value: DataAwsGlueScriptDagNode[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
