import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsIamPolicyDocumentConfig extends TerraformMetaArguments {
    readonly overrideJson?: string;
    readonly policyId?: string;
    readonly sourceJson?: string;
    readonly version?: string;
    /** statement block */
    readonly statement?: DataAwsIamPolicyDocumentStatement[];
}
export interface DataAwsIamPolicyDocumentStatementCondition {
    readonly test: string;
    readonly values: string[];
    readonly variable: string;
}
export interface DataAwsIamPolicyDocumentStatementNotPrincipals {
    readonly identifiers: string[];
    readonly type: string;
}
export interface DataAwsIamPolicyDocumentStatementPrincipals {
    readonly identifiers: string[];
    readonly type: string;
}
export interface DataAwsIamPolicyDocumentStatement {
    readonly actions?: string[];
    readonly effect?: string;
    readonly notActions?: string[];
    readonly notResources?: string[];
    readonly resources?: string[];
    readonly sid?: string;
    /** condition block */
    readonly condition?: DataAwsIamPolicyDocumentStatementCondition[];
    /** not_principals block */
    readonly notPrincipals?: DataAwsIamPolicyDocumentStatementNotPrincipals[];
    /** principals block */
    readonly principals?: DataAwsIamPolicyDocumentStatementPrincipals[];
}
export declare class DataAwsIamPolicyDocument extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsIamPolicyDocumentConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get json(): string;
    private _overrideJson?;
    get overrideJson(): string | undefined;
    set overrideJson(value: string | undefined);
    private _policyId?;
    get policyId(): string | undefined;
    set policyId(value: string | undefined);
    private _sourceJson?;
    get sourceJson(): string | undefined;
    set sourceJson(value: string | undefined);
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    private _statement?;
    get statement(): DataAwsIamPolicyDocumentStatement[] | undefined;
    set statement(value: DataAwsIamPolicyDocumentStatement[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
