"use strict";
// https://www.terraform.io/docs/providers/aws/r/data_aws_iam_policy_document.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAwsIamPolicyDocument = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DataAwsIamPolicyDocument extends cdktf_1.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_iam_policy_document',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._overrideJson = config.overrideJson;
        this._policyId = config.policyId;
        this._sourceJson = config.sourceJson;
        this._version = config.version;
        this._statement = config.statement;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // json - computed: true, optional: false, required: true
    get json() {
        return this.getStringAttribute('json');
    }
    get overrideJson() {
        return this._overrideJson;
    }
    set overrideJson(value) {
        this._overrideJson = value;
    }
    get policyId() {
        return this._policyId;
    }
    set policyId(value) {
        this._policyId = value;
    }
    get sourceJson() {
        return this._sourceJson;
    }
    set sourceJson(value) {
        this._sourceJson = value;
    }
    get version() {
        return this._version;
    }
    set version(value) {
        this._version = value;
    }
    get statement() {
        return this._statement;
    }
    set statement(value) {
        this._statement = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            override_json: this._overrideJson,
            policy_id: this._policyId,
            source_json: this._sourceJson,
            version: this._version,
            statement: this._statement,
        };
    }
}
exports.DataAwsIamPolicyDocument = DataAwsIamPolicyDocument;
//# sourceMappingURL=data:application/json;base64,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