import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsIamRoleConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly roleName?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsIamRole extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsIamRoleConfig);
    get arn(): string;
    get assumeRolePolicy(): string;
    get assumeRolePolicyDocument(): string;
    get createDate(): string;
    get description(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get maxSessionDuration(): number;
    private _name;
    get name(): string;
    set name(value: string);
    get path(): string;
    get permissionsBoundary(): string;
    get roleId(): string;
    private _roleName?;
    get roleName(): string | undefined;
    set roleName(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get uniqueId(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
