import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsInstanceConfig extends TerraformMetaArguments {
    readonly fetchPasswordData?: boolean;
    readonly fetchUserData?: boolean;
    readonly instanceId?: string;
    readonly instanceTags?: {
        [key: string]: string;
    };
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsInstanceFilter[];
}
export declare class DataAwsInstanceCreditSpecification extends ComplexComputedList {
    get cpuCredits(): string;
}
export declare class DataAwsInstanceEbsBlockDevice extends ComplexComputedList {
    get deleteOnTermination(): boolean;
    get deviceName(): string;
    get encrypted(): boolean;
    get iops(): number;
    get kmsKeyId(): string;
    get snapshotId(): string;
    get volumeId(): string;
    get volumeSize(): number;
    get volumeType(): string;
}
export declare class DataAwsInstanceEphemeralBlockDevice extends ComplexComputedList {
    get deviceName(): string;
    get noDevice(): boolean;
    get virtualName(): string;
}
export declare class DataAwsInstanceMetadataOptions extends ComplexComputedList {
    get httpEndpoint(): string;
    get httpPutResponseHopLimit(): number;
    get httpTokens(): string;
}
export declare class DataAwsInstanceRootBlockDevice extends ComplexComputedList {
    get deleteOnTermination(): boolean;
    get deviceName(): string;
    get encrypted(): boolean;
    get iops(): number;
    get kmsKeyId(): string;
    get volumeId(): string;
    get volumeSize(): number;
    get volumeType(): string;
}
export interface DataAwsInstanceFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsInstance extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsInstanceConfig);
    get ami(): string;
    get arn(): string;
    get associatePublicIpAddress(): boolean;
    get availabilityZone(): string;
    creditSpecification(index: string): DataAwsInstanceCreditSpecification;
    get disableApiTermination(): boolean;
    ebsBlockDevice(index: string): DataAwsInstanceEbsBlockDevice;
    get ebsOptimized(): boolean;
    ephemeralBlockDevice(index: string): DataAwsInstanceEphemeralBlockDevice;
    private _getPasswordData?;
    get fetchPasswordData(): boolean | undefined;
    set fetchPasswordData(value: boolean | undefined);
    private _getUserData?;
    get fetchUserData(): boolean | undefined;
    set fetchUserData(value: boolean | undefined);
    get hostId(): string;
    get iamInstanceProfile(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceId?;
    get instanceId(): string | undefined;
    set instanceId(value: string | undefined);
    get instanceState(): string;
    private _instanceTags?;
    get instanceTags(): {
        [key: string]: string;
    } | undefined;
    set instanceTags(value: {
        [key: string]: string;
    } | undefined);
    get instanceType(): string;
    get keyName(): string;
    metadataOptions(index: string): DataAwsInstanceMetadataOptions;
    get monitoring(): boolean;
    get networkInterfaceId(): string;
    get outpostArn(): string;
    get passwordData(): string;
    get placementGroup(): string;
    get privateDns(): string;
    get privateIp(): string;
    get publicDns(): string;
    get publicIp(): string;
    rootBlockDevice(index: string): DataAwsInstanceRootBlockDevice;
    get securityGroups(): string[];
    get sourceDestCheck(): boolean;
    get subnetId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get tenancy(): string;
    get userData(): string;
    get userDataBase64(): string;
    get vpcSecurityGroupIds(): string[];
    private _filter?;
    get filter(): DataAwsInstanceFilter[] | undefined;
    set filter(value: DataAwsInstanceFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
