import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsInstancesConfig extends TerraformMetaArguments {
    readonly instanceStateNames?: string[];
    readonly instanceTags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsInstancesFilter[];
}
export interface DataAwsInstancesFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsInstances extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsInstancesConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ids(): string[];
    private _instanceStateNames?;
    get instanceStateNames(): string[] | undefined;
    set instanceStateNames(value: string[] | undefined);
    private _instanceTags?;
    get instanceTags(): {
        [key: string]: string;
    } | undefined;
    set instanceTags(value: {
        [key: string]: string;
    } | undefined);
    get privateIps(): string[];
    get publicIps(): string[];
    private _filter?;
    get filter(): DataAwsInstancesFilter[] | undefined;
    set filter(value: DataAwsInstancesFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
