import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsInternetGatewayConfig extends TerraformMetaArguments {
    readonly internetGatewayId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsInternetGatewayFilter[];
}
export declare class DataAwsInternetGatewayAttachments extends ComplexComputedList {
    get state(): string;
    get vpcId(): string;
}
export interface DataAwsInternetGatewayFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsInternetGateway extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsInternetGatewayConfig);
    get arn(): string;
    attachments(index: string): DataAwsInternetGatewayAttachments;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _internetGatewayId?;
    get internetGatewayId(): string | undefined;
    set internetGatewayId(value: string | undefined);
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _filter?;
    get filter(): DataAwsInternetGatewayFilter[] | undefined;
    set filter(value: DataAwsInternetGatewayFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
