import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsKinesisStreamConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsKinesisStream extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsKinesisStreamConfig);
    get arn(): string;
    get closedShards(): string[];
    get creationTimestamp(): number;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get openShards(): string[];
    get retentionPeriod(): number;
    get shardLevelMetrics(): string[];
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
