import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsKmsKeyConfig extends TerraformMetaArguments {
    readonly grantTokens?: string[];
    readonly keyId: string;
}
export declare class DataAwsKmsKey extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsKmsKeyConfig);
    get arn(): string;
    get awsAccountId(): string;
    get creationDate(): string;
    get customerMasterKeySpec(): string;
    get deletionDate(): string;
    get description(): string;
    get enabled(): boolean;
    get expirationModel(): string;
    private _grantTokens?;
    get grantTokens(): string[] | undefined;
    set grantTokens(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _keyId;
    get keyId(): string;
    set keyId(value: string);
    get keyManager(): string;
    get keyState(): string;
    get keyUsage(): string;
    get origin(): string;
    get validTo(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
