import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsLambdaFunctionConfig extends TerraformMetaArguments {
    readonly functionName: string;
    readonly qualifier?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsLambdaFunctionDeadLetterConfig extends ComplexComputedList {
    get targetArn(): string;
}
export declare class DataAwsLambdaFunctionEnvironment extends ComplexComputedList {
    get variables(): any;
}
export declare class DataAwsLambdaFunctionFileSystemConfig extends ComplexComputedList {
    get arn(): string;
    get localMountPath(): string;
}
export declare class DataAwsLambdaFunctionTracingConfig extends ComplexComputedList {
    get mode(): string;
}
export declare class DataAwsLambdaFunctionVpcConfig extends ComplexComputedList {
    get securityGroupIds(): string[];
    get subnetIds(): string[];
    get vpcId(): string;
}
export declare class DataAwsLambdaFunction extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsLambdaFunctionConfig);
    get arn(): string;
    deadLetterConfig(index: string): DataAwsLambdaFunctionDeadLetterConfig;
    get description(): string;
    environment(index: string): DataAwsLambdaFunctionEnvironment;
    fileSystemConfig(index: string): DataAwsLambdaFunctionFileSystemConfig;
    private _functionName;
    get functionName(): string;
    set functionName(value: string);
    get handler(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get invokeArn(): string;
    get kmsKeyArn(): string;
    get lastModified(): string;
    get layers(): string[];
    get memorySize(): number;
    get qualifiedArn(): string;
    private _qualifier?;
    get qualifier(): string | undefined;
    set qualifier(value: string | undefined);
    get reservedConcurrentExecutions(): number;
    get role(): string;
    get runtime(): string;
    get sourceCodeHash(): string;
    get sourceCodeSize(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get timeout(): number;
    tracingConfig(index: string): DataAwsLambdaFunctionTracingConfig;
    get version(): string;
    vpcConfig(index: string): DataAwsLambdaFunctionVpcConfig;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
