import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsLaunchConfigurationConfig extends TerraformMetaArguments {
    readonly name: string;
}
export declare class DataAwsLaunchConfigurationEbsBlockDevice extends ComplexComputedList {
    get deleteOnTermination(): boolean;
    get deviceName(): string;
    get encrypted(): boolean;
    get iops(): number;
    get snapshotId(): string;
    get volumeSize(): number;
    get volumeType(): string;
}
export declare class DataAwsLaunchConfigurationEphemeralBlockDevice extends ComplexComputedList {
    get deviceName(): string;
    get virtualName(): string;
}
export declare class DataAwsLaunchConfigurationRootBlockDevice extends ComplexComputedList {
    get deleteOnTermination(): boolean;
    get encrypted(): boolean;
    get iops(): number;
    get volumeSize(): number;
    get volumeType(): string;
}
export declare class DataAwsLaunchConfiguration extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsLaunchConfigurationConfig);
    get arn(): string;
    get associatePublicIpAddress(): boolean;
    ebsBlockDevice(index: string): DataAwsLaunchConfigurationEbsBlockDevice;
    get ebsOptimized(): boolean;
    get enableMonitoring(): boolean;
    ephemeralBlockDevice(index: string): DataAwsLaunchConfigurationEphemeralBlockDevice;
    get iamInstanceProfile(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get imageId(): string;
    get instanceType(): string;
    get keyName(): string;
    private _name;
    get name(): string;
    set name(value: string);
    get placementTenancy(): string;
    rootBlockDevice(index: string): DataAwsLaunchConfigurationRootBlockDevice;
    get securityGroups(): string[];
    get spotPrice(): string;
    get userData(): string;
    get vpcClassicLinkId(): string;
    get vpcClassicLinkSecurityGroups(): string[];
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
