import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsLaunchTemplateConfig extends TerraformMetaArguments {
    readonly name?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsLaunchTemplateFilter[];
}
export declare class DataAwsLaunchTemplateBlockDeviceMappingsEbs extends ComplexComputedList {
    get deleteOnTermination(): string;
    get encrypted(): string;
    get iops(): number;
    get kmsKeyId(): string;
    get snapshotId(): string;
    get volumeSize(): number;
    get volumeType(): string;
}
export declare class DataAwsLaunchTemplateBlockDeviceMappings extends ComplexComputedList {
    get deviceName(): string;
    get ebs(): any;
    get noDevice(): string;
    get virtualName(): string;
}
export declare class DataAwsLaunchTemplateCreditSpecification extends ComplexComputedList {
    get cpuCredits(): string;
}
export declare class DataAwsLaunchTemplateElasticGpuSpecifications extends ComplexComputedList {
    get type(): string;
}
export declare class DataAwsLaunchTemplateHibernationOptions extends ComplexComputedList {
    get configured(): boolean;
}
export declare class DataAwsLaunchTemplateIamInstanceProfile extends ComplexComputedList {
    get arn(): string;
    get name(): string;
}
export declare class DataAwsLaunchTemplateInstanceMarketOptionsSpotOptions extends ComplexComputedList {
    get blockDurationMinutes(): number;
    get instanceInterruptionBehavior(): string;
    get maxPrice(): string;
    get spotInstanceType(): string;
    get validUntil(): string;
}
export declare class DataAwsLaunchTemplateInstanceMarketOptions extends ComplexComputedList {
    get marketType(): string;
    get spotOptions(): any;
}
export declare class DataAwsLaunchTemplateMetadataOptions extends ComplexComputedList {
    get httpEndpoint(): string;
    get httpPutResponseHopLimit(): number;
    get httpTokens(): string;
}
export declare class DataAwsLaunchTemplateMonitoring extends ComplexComputedList {
    get enabled(): boolean;
}
export declare class DataAwsLaunchTemplateNetworkInterfaces extends ComplexComputedList {
    get associatePublicIpAddress(): string;
    get deleteOnTermination(): boolean;
    get description(): string;
    get deviceIndex(): number;
    get ipv4AddressCount(): number;
    get ipv4Addresses(): string[];
    get ipv6AddressCount(): number;
    get ipv6Addresses(): string[];
    get networkInterfaceId(): string;
    get privateIpAddress(): string;
    get securityGroups(): string[];
    get subnetId(): string;
}
export declare class DataAwsLaunchTemplatePlacement extends ComplexComputedList {
    get affinity(): string;
    get availabilityZone(): string;
    get groupName(): string;
    get hostId(): string;
    get partitionNumber(): number;
    get spreadDomain(): string;
    get tenancy(): string;
}
export declare class DataAwsLaunchTemplateTagSpecifications extends ComplexComputedList {
    get resourceType(): string;
    get tags(): any;
}
export interface DataAwsLaunchTemplateFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsLaunchTemplate extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsLaunchTemplateConfig);
    get arn(): string;
    blockDeviceMappings(index: string): DataAwsLaunchTemplateBlockDeviceMappings;
    creditSpecification(index: string): DataAwsLaunchTemplateCreditSpecification;
    get defaultVersion(): number;
    get description(): string;
    get disableApiTermination(): boolean;
    get ebsOptimized(): string;
    elasticGpuSpecifications(index: string): DataAwsLaunchTemplateElasticGpuSpecifications;
    hibernationOptions(index: string): DataAwsLaunchTemplateHibernationOptions;
    iamInstanceProfile(index: string): DataAwsLaunchTemplateIamInstanceProfile;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get imageId(): string;
    get instanceInitiatedShutdownBehavior(): string;
    instanceMarketOptions(index: string): DataAwsLaunchTemplateInstanceMarketOptions;
    get instanceType(): string;
    get kernelId(): string;
    get keyName(): string;
    get latestVersion(): number;
    metadataOptions(index: string): DataAwsLaunchTemplateMetadataOptions;
    monitoring(index: string): DataAwsLaunchTemplateMonitoring;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    networkInterfaces(index: string): DataAwsLaunchTemplateNetworkInterfaces;
    placement(index: string): DataAwsLaunchTemplatePlacement;
    get ramDiskId(): string;
    get securityGroupNames(): string[];
    tagSpecifications(index: string): DataAwsLaunchTemplateTagSpecifications;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get userData(): string;
    get vpcSecurityGroupIds(): string[];
    private _filter?;
    get filter(): DataAwsLaunchTemplateFilter[] | undefined;
    set filter(value: DataAwsLaunchTemplateFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
