import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsLbListenerConfig extends TerraformMetaArguments {
    readonly loadBalancerArn?: string;
    readonly port?: number;
}
export declare class DataAwsLbListenerDefaultActionAuthenticateCognito extends ComplexComputedList {
    get authenticationRequestExtraParams(): any;
    get onUnauthenticatedRequest(): string;
    get scope(): string;
    get sessionCookieName(): string;
    get sessionTimeout(): number;
    get userPoolArn(): string;
    get userPoolClientId(): string;
    get userPoolDomain(): string;
}
export declare class DataAwsLbListenerDefaultActionAuthenticateOidc extends ComplexComputedList {
    get authenticationRequestExtraParams(): any;
    get authorizationEndpoint(): string;
    get clientId(): string;
    get clientSecret(): string;
    get issuer(): string;
    get onUnauthenticatedRequest(): string;
    get scope(): string;
    get sessionCookieName(): string;
    get sessionTimeout(): number;
    get tokenEndpoint(): string;
    get userInfoEndpoint(): string;
}
export declare class DataAwsLbListenerDefaultActionFixedResponse extends ComplexComputedList {
    get contentType(): string;
    get messageBody(): string;
    get statusCode(): string;
}
export declare class DataAwsLbListenerDefaultActionRedirect extends ComplexComputedList {
    get host(): string;
    get path(): string;
    get port(): string;
    get protocol(): string;
    get query(): string;
    get statusCode(): string;
}
export declare class DataAwsLbListenerDefaultAction extends ComplexComputedList {
    get authenticateCognito(): any;
    get authenticateOidc(): any;
    get fixedResponse(): any;
    get order(): number;
    get redirect(): any;
    get targetGroupArn(): string;
    get type(): string;
}
export declare class DataAwsLbListener extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsLbListenerConfig);
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    get certificateArn(): string;
    defaultAction(index: string): DataAwsLbListenerDefaultAction;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _loadBalancerArn?;
    get loadBalancerArn(): string | undefined;
    set loadBalancerArn(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    get protocol(): string;
    get sslPolicy(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
