"use strict";
// https://www.terraform.io/docs/providers/aws/r/data_aws_lb_listener.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAwsLbListener = exports.DataAwsLbListenerDefaultAction = exports.DataAwsLbListenerDefaultActionRedirect = exports.DataAwsLbListenerDefaultActionFixedResponse = exports.DataAwsLbListenerDefaultActionAuthenticateOidc = exports.DataAwsLbListenerDefaultActionAuthenticateCognito = void 0;
const cdktf_1 = require("cdktf");
const cdktf_2 = require("cdktf");
class DataAwsLbListenerDefaultActionAuthenticateCognito extends cdktf_2.ComplexComputedList {
    // authentication_request_extra_params - computed: true, optional: false, required: true
    get authenticationRequestExtraParams() {
        return 'not implemented';
    }
    // on_unauthenticated_request - computed: true, optional: false, required: true
    get onUnauthenticatedRequest() {
        return this.getStringAttribute('on_unauthenticated_request');
    }
    // scope - computed: true, optional: false, required: true
    get scope() {
        return this.getStringAttribute('scope');
    }
    // session_cookie_name - computed: true, optional: false, required: true
    get sessionCookieName() {
        return this.getStringAttribute('session_cookie_name');
    }
    // session_timeout - computed: true, optional: false, required: true
    get sessionTimeout() {
        return this.getNumberAttribute('session_timeout');
    }
    // user_pool_arn - computed: true, optional: false, required: true
    get userPoolArn() {
        return this.getStringAttribute('user_pool_arn');
    }
    // user_pool_client_id - computed: true, optional: false, required: true
    get userPoolClientId() {
        return this.getStringAttribute('user_pool_client_id');
    }
    // user_pool_domain - computed: true, optional: false, required: true
    get userPoolDomain() {
        return this.getStringAttribute('user_pool_domain');
    }
}
exports.DataAwsLbListenerDefaultActionAuthenticateCognito = DataAwsLbListenerDefaultActionAuthenticateCognito;
class DataAwsLbListenerDefaultActionAuthenticateOidc extends cdktf_2.ComplexComputedList {
    // authentication_request_extra_params - computed: true, optional: false, required: true
    get authenticationRequestExtraParams() {
        return 'not implemented';
    }
    // authorization_endpoint - computed: true, optional: false, required: true
    get authorizationEndpoint() {
        return this.getStringAttribute('authorization_endpoint');
    }
    // client_id - computed: true, optional: false, required: true
    get clientId() {
        return this.getStringAttribute('client_id');
    }
    // client_secret - computed: true, optional: false, required: true
    get clientSecret() {
        return this.getStringAttribute('client_secret');
    }
    // issuer - computed: true, optional: false, required: true
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    // on_unauthenticated_request - computed: true, optional: false, required: true
    get onUnauthenticatedRequest() {
        return this.getStringAttribute('on_unauthenticated_request');
    }
    // scope - computed: true, optional: false, required: true
    get scope() {
        return this.getStringAttribute('scope');
    }
    // session_cookie_name - computed: true, optional: false, required: true
    get sessionCookieName() {
        return this.getStringAttribute('session_cookie_name');
    }
    // session_timeout - computed: true, optional: false, required: true
    get sessionTimeout() {
        return this.getNumberAttribute('session_timeout');
    }
    // token_endpoint - computed: true, optional: false, required: true
    get tokenEndpoint() {
        return this.getStringAttribute('token_endpoint');
    }
    // user_info_endpoint - computed: true, optional: false, required: true
    get userInfoEndpoint() {
        return this.getStringAttribute('user_info_endpoint');
    }
}
exports.DataAwsLbListenerDefaultActionAuthenticateOidc = DataAwsLbListenerDefaultActionAuthenticateOidc;
class DataAwsLbListenerDefaultActionFixedResponse extends cdktf_2.ComplexComputedList {
    // content_type - computed: true, optional: false, required: true
    get contentType() {
        return this.getStringAttribute('content_type');
    }
    // message_body - computed: true, optional: false, required: true
    get messageBody() {
        return this.getStringAttribute('message_body');
    }
    // status_code - computed: true, optional: false, required: true
    get statusCode() {
        return this.getStringAttribute('status_code');
    }
}
exports.DataAwsLbListenerDefaultActionFixedResponse = DataAwsLbListenerDefaultActionFixedResponse;
class DataAwsLbListenerDefaultActionRedirect extends cdktf_2.ComplexComputedList {
    // host - computed: true, optional: false, required: true
    get host() {
        return this.getStringAttribute('host');
    }
    // path - computed: true, optional: false, required: true
    get path() {
        return this.getStringAttribute('path');
    }
    // port - computed: true, optional: false, required: true
    get port() {
        return this.getStringAttribute('port');
    }
    // protocol - computed: true, optional: false, required: true
    get protocol() {
        return this.getStringAttribute('protocol');
    }
    // query - computed: true, optional: false, required: true
    get query() {
        return this.getStringAttribute('query');
    }
    // status_code - computed: true, optional: false, required: true
    get statusCode() {
        return this.getStringAttribute('status_code');
    }
}
exports.DataAwsLbListenerDefaultActionRedirect = DataAwsLbListenerDefaultActionRedirect;
class DataAwsLbListenerDefaultAction extends cdktf_2.ComplexComputedList {
    // authenticate_cognito - computed: true, optional: false, required: true
    get authenticateCognito() {
        return 'not implemented';
    }
    // authenticate_oidc - computed: true, optional: false, required: true
    get authenticateOidc() {
        return 'not implemented';
    }
    // fixed_response - computed: true, optional: false, required: true
    get fixedResponse() {
        return 'not implemented';
    }
    // order - computed: true, optional: false, required: true
    get order() {
        return this.getNumberAttribute('order');
    }
    // redirect - computed: true, optional: false, required: true
    get redirect() {
        return 'not implemented';
    }
    // target_group_arn - computed: true, optional: false, required: true
    get targetGroupArn() {
        return this.getStringAttribute('target_group_arn');
    }
    // type - computed: true, optional: false, required: true
    get type() {
        return this.getStringAttribute('type');
    }
}
exports.DataAwsLbListenerDefaultAction = DataAwsLbListenerDefaultAction;
// Resource
class DataAwsLbListener extends cdktf_1.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_lb_listener',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._loadBalancerArn = config.loadBalancerArn;
        this._port = config.port;
    }
    get arn() {
        var _a;
        return (_a = this._arn) !== null && _a !== void 0 ? _a : this.getStringAttribute('arn');
    }
    set arn(value) {
        this._arn = value;
    }
    // certificate_arn - computed: true, optional: false, required: true
    get certificateArn() {
        return this.getStringAttribute('certificate_arn');
    }
    // default_action - computed: true, optional: false, required: true
    defaultAction(index) {
        return new DataAwsLbListenerDefaultAction(this, 'default_action', index);
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get loadBalancerArn() {
        var _a;
        return (_a = this._loadBalancerArn) !== null && _a !== void 0 ? _a : this.getStringAttribute('load_balancer_arn');
    }
    set loadBalancerArn(value) {
        this._loadBalancerArn = value;
    }
    get port() {
        var _a;
        return (_a = this._port) !== null && _a !== void 0 ? _a : this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    // protocol - computed: true, optional: false, required: true
    get protocol() {
        return this.getStringAttribute('protocol');
    }
    // ssl_policy - computed: true, optional: false, required: true
    get sslPolicy() {
        return this.getStringAttribute('ssl_policy');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            load_balancer_arn: this._loadBalancerArn,
            port: this._port,
        };
    }
}
exports.DataAwsLbListener = DataAwsLbListener;
//# sourceMappingURL=data:application/json;base64,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