import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsMqBrokerConfig extends TerraformMetaArguments {
    readonly brokerId?: string;
    readonly brokerName?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** logs block */
    readonly logs?: DataAwsMqBrokerLogs[];
}
export declare class DataAwsMqBrokerConfiguration extends ComplexComputedList {
    get id(): string;
    get revision(): number;
}
export declare class DataAwsMqBrokerEncryptionOptions extends ComplexComputedList {
    get kmsKeyId(): string;
    get useAwsOwnedKey(): boolean;
}
export declare class DataAwsMqBrokerInstances extends ComplexComputedList {
    get consoleUrl(): string;
    get endpoints(): string[];
    get ipAddress(): string;
}
export declare class DataAwsMqBrokerMaintenanceWindowStartTime extends ComplexComputedList {
    get dayOfWeek(): string;
    get timeOfDay(): string;
    get timeZone(): string;
}
export declare class DataAwsMqBrokerUser extends ComplexComputedList {
    get consoleAccess(): boolean;
    get groups(): string[];
    get username(): string;
}
export interface DataAwsMqBrokerLogs {
}
export declare class DataAwsMqBroker extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsMqBrokerConfig);
    get arn(): string;
    get autoMinorVersionUpgrade(): boolean;
    private _brokerId?;
    get brokerId(): string | undefined;
    set brokerId(value: string | undefined);
    private _brokerName?;
    get brokerName(): string | undefined;
    set brokerName(value: string | undefined);
    configuration(index: string): DataAwsMqBrokerConfiguration;
    get deploymentMode(): string;
    encryptionOptions(index: string): DataAwsMqBrokerEncryptionOptions;
    get engineType(): string;
    get engineVersion(): string;
    get hostInstanceType(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    instances(index: string): DataAwsMqBrokerInstances;
    maintenanceWindowStartTime(index: string): DataAwsMqBrokerMaintenanceWindowStartTime;
    get publiclyAccessible(): boolean;
    get securityGroups(): string[];
    get subnetIds(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    user(index: string): DataAwsMqBrokerUser;
    private _logs?;
    get logs(): DataAwsMqBrokerLogs[] | undefined;
    set logs(value: DataAwsMqBrokerLogs[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
