"use strict";
// https://www.terraform.io/docs/providers/aws/r/data_aws_mq_broker.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAwsMqBroker = exports.DataAwsMqBrokerUser = exports.DataAwsMqBrokerMaintenanceWindowStartTime = exports.DataAwsMqBrokerInstances = exports.DataAwsMqBrokerEncryptionOptions = exports.DataAwsMqBrokerConfiguration = void 0;
const cdktf_1 = require("cdktf");
const cdktf_2 = require("cdktf");
class DataAwsMqBrokerConfiguration extends cdktf_2.ComplexComputedList {
    // id - computed: true, optional: false, required: true
    get id() {
        return this.getStringAttribute('id');
    }
    // revision - computed: true, optional: false, required: true
    get revision() {
        return this.getNumberAttribute('revision');
    }
}
exports.DataAwsMqBrokerConfiguration = DataAwsMqBrokerConfiguration;
class DataAwsMqBrokerEncryptionOptions extends cdktf_2.ComplexComputedList {
    // kms_key_id - computed: true, optional: false, required: true
    get kmsKeyId() {
        return this.getStringAttribute('kms_key_id');
    }
    // use_aws_owned_key - computed: true, optional: false, required: true
    get useAwsOwnedKey() {
        return this.getBooleanAttribute('use_aws_owned_key');
    }
}
exports.DataAwsMqBrokerEncryptionOptions = DataAwsMqBrokerEncryptionOptions;
class DataAwsMqBrokerInstances extends cdktf_2.ComplexComputedList {
    // console_url - computed: true, optional: false, required: true
    get consoleUrl() {
        return this.getStringAttribute('console_url');
    }
    // endpoints - computed: true, optional: false, required: true
    get endpoints() {
        return this.getListAttribute('endpoints');
    }
    // ip_address - computed: true, optional: false, required: true
    get ipAddress() {
        return this.getStringAttribute('ip_address');
    }
}
exports.DataAwsMqBrokerInstances = DataAwsMqBrokerInstances;
class DataAwsMqBrokerMaintenanceWindowStartTime extends cdktf_2.ComplexComputedList {
    // day_of_week - computed: true, optional: false, required: true
    get dayOfWeek() {
        return this.getStringAttribute('day_of_week');
    }
    // time_of_day - computed: true, optional: false, required: true
    get timeOfDay() {
        return this.getStringAttribute('time_of_day');
    }
    // time_zone - computed: true, optional: false, required: true
    get timeZone() {
        return this.getStringAttribute('time_zone');
    }
}
exports.DataAwsMqBrokerMaintenanceWindowStartTime = DataAwsMqBrokerMaintenanceWindowStartTime;
class DataAwsMqBrokerUser extends cdktf_2.ComplexComputedList {
    // console_access - computed: true, optional: false, required: true
    get consoleAccess() {
        return this.getBooleanAttribute('console_access');
    }
    // groups - computed: true, optional: false, required: true
    get groups() {
        return this.getListAttribute('groups');
    }
    // username - computed: true, optional: false, required: true
    get username() {
        return this.getStringAttribute('username');
    }
}
exports.DataAwsMqBrokerUser = DataAwsMqBrokerUser;
// Resource
class DataAwsMqBroker extends cdktf_1.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_mq_broker',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._brokerId = config.brokerId;
        this._brokerName = config.brokerName;
        this._tags = config.tags;
        this._logs = config.logs;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    // auto_minor_version_upgrade - computed: true, optional: false, required: true
    get autoMinorVersionUpgrade() {
        return this.getBooleanAttribute('auto_minor_version_upgrade');
    }
    get brokerId() {
        var _a;
        return (_a = this._brokerId) !== null && _a !== void 0 ? _a : this.getStringAttribute('broker_id');
    }
    set brokerId(value) {
        this._brokerId = value;
    }
    get brokerName() {
        var _a;
        return (_a = this._brokerName) !== null && _a !== void 0 ? _a : this.getStringAttribute('broker_name');
    }
    set brokerName(value) {
        this._brokerName = value;
    }
    // configuration - computed: true, optional: false, required: true
    configuration(index) {
        return new DataAwsMqBrokerConfiguration(this, 'configuration', index);
    }
    // deployment_mode - computed: true, optional: false, required: true
    get deploymentMode() {
        return this.getStringAttribute('deployment_mode');
    }
    // encryption_options - computed: true, optional: false, required: true
    encryptionOptions(index) {
        return new DataAwsMqBrokerEncryptionOptions(this, 'encryption_options', index);
    }
    // engine_type - computed: true, optional: false, required: true
    get engineType() {
        return this.getStringAttribute('engine_type');
    }
    // engine_version - computed: true, optional: false, required: true
    get engineVersion() {
        return this.getStringAttribute('engine_version');
    }
    // host_instance_type - computed: true, optional: false, required: true
    get hostInstanceType() {
        return this.getStringAttribute('host_instance_type');
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    // instances - computed: true, optional: false, required: true
    instances(index) {
        return new DataAwsMqBrokerInstances(this, 'instances', index);
    }
    // maintenance_window_start_time - computed: true, optional: false, required: true
    maintenanceWindowStartTime(index) {
        return new DataAwsMqBrokerMaintenanceWindowStartTime(this, 'maintenance_window_start_time', index);
    }
    // publicly_accessible - computed: true, optional: false, required: true
    get publiclyAccessible() {
        return this.getBooleanAttribute('publicly_accessible');
    }
    // security_groups - computed: true, optional: false, required: true
    get securityGroups() {
        return this.getListAttribute('security_groups');
    }
    // subnet_ids - computed: true, optional: false, required: true
    get subnetIds() {
        return this.getListAttribute('subnet_ids');
    }
    get tags() {
        return this._tags; // Getting the computed value is not yet implemented
    }
    set tags(value) {
        this._tags = value;
    }
    // user - computed: true, optional: false, required: true
    user(index) {
        return new DataAwsMqBrokerUser(this, 'user', index);
    }
    get logs() {
        return this._logs;
    }
    set logs(value) {
        this._logs = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            broker_id: this._brokerId,
            broker_name: this._brokerName,
            tags: this._tags,
            logs: this._logs,
        };
    }
}
exports.DataAwsMqBroker = DataAwsMqBroker;
//# sourceMappingURL=data:application/json;base64,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