import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsMskClusterConfig extends TerraformMetaArguments {
    readonly clusterName: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsMskCluster extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsMskClusterConfig);
    get arn(): string;
    get bootstrapBrokers(): string;
    get bootstrapBrokersTls(): string;
    private _clusterName;
    get clusterName(): string;
    set clusterName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kafkaVersion(): string;
    get numberOfBrokerNodes(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get zookeeperConnectString(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
