import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsNatGatewayConfig extends TerraformMetaArguments {
    readonly state?: string;
    readonly subnetId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    /** filter block */
    readonly filter?: DataAwsNatGatewayFilter[];
}
export interface DataAwsNatGatewayFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsNatGateway extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsNatGatewayConfig);
    get allocationId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get networkInterfaceId(): string;
    get privateIp(): string;
    get publicIp(): string;
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _filter?;
    get filter(): DataAwsNatGatewayFilter[] | undefined;
    set filter(value: DataAwsNatGatewayFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
