import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsNetworkInterfaceConfig extends TerraformMetaArguments {
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsNetworkInterfaceFilter[];
}
export declare class DataAwsNetworkInterfaceAssociation extends ComplexComputedList {
    get allocationId(): string;
    get associationId(): string;
    get ipOwnerId(): string;
    get publicDnsName(): string;
    get publicIp(): string;
}
export declare class DataAwsNetworkInterfaceAttachment extends ComplexComputedList {
    get attachmentId(): string;
    get deviceIndex(): number;
    get instanceId(): string;
    get instanceOwnerId(): string;
}
export interface DataAwsNetworkInterfaceFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsNetworkInterface extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsNetworkInterfaceConfig);
    association(index: string): DataAwsNetworkInterfaceAssociation;
    attachment(index: string): DataAwsNetworkInterfaceAttachment;
    get availabilityZone(): string;
    get description(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get interfaceType(): string;
    get ipv6Addresses(): string[];
    get macAddress(): string;
    get outpostArn(): string;
    get ownerId(): string;
    get privateDnsName(): string;
    get privateIp(): string;
    get privateIps(): string[];
    get requesterId(): string;
    get securityGroups(): string[];
    get subnetId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    private _filter?;
    get filter(): DataAwsNetworkInterfaceFilter[] | undefined;
    set filter(value: DataAwsNetworkInterfaceFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
