import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsRamResourceShareConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly resourceOwner: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsRamResourceShareFilter[];
}
export interface DataAwsRamResourceShareFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsRamResourceShare extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsRamResourceShareConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get owningAccountId(): string;
    private _resourceOwner;
    get resourceOwner(): string;
    set resourceOwner(value: string);
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _filter?;
    get filter(): DataAwsRamResourceShareFilter[] | undefined;
    set filter(value: DataAwsRamResourceShareFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
