import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsRdsClusterConfig extends TerraformMetaArguments {
    readonly clusterIdentifier: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsRdsCluster extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsRdsClusterConfig);
    get arn(): string;
    get availabilityZones(): string[];
    get backtrackWindow(): number;
    get backupRetentionPeriod(): number;
    private _clusterIdentifier;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    get clusterMembers(): string[];
    get clusterResourceId(): string;
    get databaseName(): string;
    get dbClusterParameterGroupName(): string;
    get dbSubnetGroupName(): string;
    get enabledCloudwatchLogsExports(): string[];
    get endpoint(): string;
    get engine(): string;
    get engineVersion(): string;
    get finalSnapshotIdentifier(): string;
    get hostedZoneId(): string;
    get iamDatabaseAuthenticationEnabled(): boolean;
    get iamRoles(): string[];
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kmsKeyId(): string;
    get masterUsername(): string;
    get port(): number;
    get preferredBackupWindow(): string;
    get preferredMaintenanceWindow(): string;
    get readerEndpoint(): string;
    get replicationSourceIdentifier(): string;
    get storageEncrypted(): boolean;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcSecurityGroupIds(): string[];
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
