import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsRedshiftClusterConfig extends TerraformMetaArguments {
    readonly clusterIdentifier: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class DataAwsRedshiftCluster extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsRedshiftClusterConfig);
    get allowVersionUpgrade(): boolean;
    get automatedSnapshotRetentionPeriod(): number;
    get availabilityZone(): string;
    get bucketName(): string;
    private _clusterIdentifier;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    get clusterParameterGroupName(): string;
    get clusterPublicKey(): string;
    get clusterRevisionNumber(): string;
    get clusterSecurityGroups(): string[];
    get clusterSubnetGroupName(): string;
    get clusterType(): string;
    get clusterVersion(): string;
    get databaseName(): string;
    get elasticIp(): string;
    get enableLogging(): boolean;
    get encrypted(): boolean;
    get endpoint(): string;
    get enhancedVpcRouting(): boolean;
    get iamRoles(): string[];
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get kmsKeyId(): string;
    get masterUsername(): string;
    get nodeType(): string;
    get numberOfNodes(): number;
    get port(): number;
    get preferredMaintenanceWindow(): string;
    get publiclyAccessible(): boolean;
    get s3KeyPrefix(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    get vpcSecurityGroupIds(): string[];
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
