"use strict";
// https://www.terraform.io/docs/providers/aws/r/data_aws_region.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAwsRegion = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DataAwsRegion extends cdktf_1.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_region',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._current = config.current;
        this._endpoint = config.endpoint;
        this._name = config.name;
    }
    get current() {
        var _a;
        return (_a = this._current) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('current');
    }
    set current(value) {
        this._current = value;
    }
    // description - computed: true, optional: false, required: true
    get description() {
        return this.getStringAttribute('description');
    }
    get endpoint() {
        var _a;
        return (_a = this._endpoint) !== null && _a !== void 0 ? _a : this.getStringAttribute('endpoint');
    }
    set endpoint(value) {
        this._endpoint = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        var _a;
        return (_a = this._name) !== null && _a !== void 0 ? _a : this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            current: this._current,
            endpoint: this._endpoint,
            name: this._name,
        };
    }
}
exports.DataAwsRegion = DataAwsRegion;
//# sourceMappingURL=data:application/json;base64,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