import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface DataAwsRouteTableConfig extends TerraformMetaArguments {
    readonly gatewayId?: string;
    readonly routeTableId?: string;
    readonly subnetId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    /** filter block */
    readonly filter?: DataAwsRouteTableFilter[];
}
export declare class DataAwsRouteTableAssociations extends ComplexComputedList {
    get gatewayId(): string;
    get main(): boolean;
    get routeTableAssociationId(): string;
    get routeTableId(): string;
    get subnetId(): string;
}
export declare class DataAwsRouteTableRoutes extends ComplexComputedList {
    get cidrBlock(): string;
    get egressOnlyGatewayId(): string;
    get gatewayId(): string;
    get instanceId(): string;
    get ipv6CidrBlock(): string;
    get natGatewayId(): string;
    get networkInterfaceId(): string;
    get transitGatewayId(): string;
    get vpcPeeringConnectionId(): string;
}
export interface DataAwsRouteTableFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsRouteTable extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsRouteTableConfig);
    associations(index: string): DataAwsRouteTableAssociations;
    private _gatewayId?;
    get gatewayId(): string | undefined;
    set gatewayId(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ownerId(): string;
    private _routeTableId?;
    get routeTableId(): string | undefined;
    set routeTableId(value: string | undefined);
    routes(index: string): DataAwsRouteTableRoutes;
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _filter?;
    get filter(): DataAwsRouteTableFilter[] | undefined;
    set filter(value: DataAwsRouteTableFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
