"use strict";
// https://www.terraform.io/docs/providers/aws/r/data_aws_route53_delegation_set.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAwsRoute53DelegationSet = void 0;
const cdktf_1 = require("cdktf");
// Resource
class DataAwsRoute53DelegationSet extends cdktf_1.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_route53_delegation_set',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._id = config.id;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // caller_reference - computed: true, optional: false, required: true
    get callerReference() {
        return this.getStringAttribute('caller_reference');
    }
    get id() {
        return this._id;
    }
    set id(value) {
        this._id = value;
    }
    // name_servers - computed: true, optional: false, required: true
    get nameServers() {
        return this.getListAttribute('name_servers');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: this._id,
        };
    }
}
exports.DataAwsRoute53DelegationSet = DataAwsRoute53DelegationSet;
//# sourceMappingURL=data:application/json;base64,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