import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsS3BucketObjectConfig extends TerraformMetaArguments {
    readonly bucket: string;
    readonly key: string;
    readonly range?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly versionId?: string;
}
export declare class DataAwsS3BucketObject extends TerraformDataSource {
    constructor(scope: Construct, id: string, config: DataAwsS3BucketObjectConfig);
    get body(): string;
    private _bucket;
    get bucket(): string;
    set bucket(value: string);
    get cacheControl(): string;
    get contentDisposition(): string;
    get contentEncoding(): string;
    get contentLanguage(): string;
    get contentLength(): number;
    get contentType(): string;
    get etag(): string;
    get expiration(): string;
    get expires(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _key;
    get key(): string;
    set key(value: string);
    get lastModified(): string;
    metadata(key: string): string;
    get objectLockLegalHoldStatus(): string;
    get objectLockMode(): string;
    get objectLockRetainUntilDate(): string;
    private _range?;
    get range(): string | undefined;
    set range(value: string | undefined);
    get serverSideEncryption(): string;
    get sseKmsKeyId(): string;
    get storageClass(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _versionId?;
    get versionId(): string | undefined;
    set versionId(value: string | undefined);
    get websiteRedirectLocation(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
