import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsSecurityGroupConfig extends TerraformMetaArguments {
    readonly name?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    /** filter block */
    readonly filter?: DataAwsSecurityGroupFilter[];
}
export interface DataAwsSecurityGroupFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsSecurityGroup extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsSecurityGroupConfig);
    get arn(): string;
    get description(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _filter?;
    get filter(): DataAwsSecurityGroupFilter[] | undefined;
    set filter(value: DataAwsSecurityGroupFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
