import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsSubnetConfig extends TerraformMetaArguments {
    readonly availabilityZone?: string;
    readonly availabilityZoneId?: string;
    readonly cidrBlock?: string;
    readonly defaultForAz?: boolean;
    readonly ipv6CidrBlock?: string;
    readonly state?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId?: string;
    /** filter block */
    readonly filter?: DataAwsSubnetFilter[];
}
export interface DataAwsSubnetFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsSubnet extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsSubnetConfig);
    get arn(): string;
    get assignIpv6AddressOnCreation(): boolean;
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _availabilityZoneId?;
    get availabilityZoneId(): string | undefined;
    set availabilityZoneId(value: string | undefined);
    private _cidrBlock?;
    get cidrBlock(): string | undefined;
    set cidrBlock(value: string | undefined);
    private _defaultForAz?;
    get defaultForAz(): boolean | undefined;
    set defaultForAz(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipv6CidrBlock?;
    get ipv6CidrBlock(): string | undefined;
    set ipv6CidrBlock(value: string | undefined);
    get ipv6CidrBlockAssociationId(): string;
    get mapPublicIpOnLaunch(): boolean;
    get outpostArn(): string;
    get ownerId(): string;
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _filter?;
    get filter(): DataAwsSubnetFilter[] | undefined;
    set filter(value: DataAwsSubnetFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
