import { Construct } from 'constructs';
import { TerraformDataSource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface DataAwsVpcDhcpOptionsConfig extends TerraformMetaArguments {
    readonly dhcpOptionsId?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** filter block */
    readonly filter?: DataAwsVpcDhcpOptionsFilter[];
}
export interface DataAwsVpcDhcpOptionsFilter {
    readonly name: string;
    readonly values: string[];
}
export declare class DataAwsVpcDhcpOptions extends TerraformDataSource {
    constructor(scope: Construct, id: string, config?: DataAwsVpcDhcpOptionsConfig);
    get arn(): string;
    private _dhcpOptionsId?;
    get dhcpOptionsId(): string | undefined;
    set dhcpOptionsId(value: string | undefined);
    get domainName(): string;
    get domainNameServers(): string[];
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get netbiosNameServers(): string[];
    get netbiosNodeType(): string;
    get ntpServers(): string[];
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _filter?;
    get filter(): DataAwsVpcDhcpOptionsFilter[] | undefined;
    set filter(value: DataAwsVpcDhcpOptionsFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
